/* ========================================
 *  Energy - Energy.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Energy_Energy_H
#define __Energy_Energy_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Energy {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kParamH = 7,
	kParamI = 8,
  kNumParameters = 9
}; //


class Energy final : public SfxCoreExtensionV1
{
public:
    Energy();
    ~Energy();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

	double duoEvenL;
	double duoOddL;
	double duoFactorL;
	bool flip;
	
	double tripletAL;
	double tripletBL;
	double tripletCL;
	double tripletFactorL;
	int countA;
	
	double quadAL;
	double quadBL;
	double quadCL;
	double quadDL;
	double quadFactorL;
	int countB;
	
	double quintAL;
	double quintBL;
	double quintCL;
	double quintDL;
	double quintEL;
	double quintFactorL;
	int countC;
	
	double sextAL;
	double sextBL;
	double sextCL;
	double sextDL;
	double sextEL;
	double sextFL;
	double sextFactorL;
	int countD;
	
	double septAL;
	double septBL;
	double septCL;
	double septDL;
	double septEL;
	double septFL;
	double septGL;
	double septFactorL;
	int countE;
	
	double octAL;
	double octBL;
	double octCL;
	double octDL;
	double octEL;
	double octFL;
	double octGL;
	double octHL;
	double octFactorL;
	int countF;
	
	double nintAL;
	double nintBL;
	double nintCL;
	double nintDL;
	double nintEL;
	double nintFL;
	double nintGL;
	double nintHL;
	double nintIL;
	double nintFactorL;
	int countG;
	
	double PrevHL;
	double PrevGL;
	double PrevFL;
	double PrevEL;
	double PrevDL;
	double PrevCL;
	double PrevBL;
	double PrevAL;
	
	double duoEvenR;
	double duoOddR;
	double duoFactorR;
	
	double tripletAR;
	double tripletBR;
	double tripletCR;
	double tripletFactorR;
	
	double quadAR;
	double quadBR;
	double quadCR;
	double quadDR;
	double quadFactorR;
	
	double quintAR;
	double quintBR;
	double quintCR;
	double quintDR;
	double quintER;
	double quintFactorR;
	
	double sextAR;
	double sextBR;
	double sextCR;
	double sextDR;
	double sextER;
	double sextFR;
	double sextFactorR;
	
	double septAR;
	double septBR;
	double septCR;
	double septDR;
	double septER;
	double septFR;
	double septGR;
	double septFactorR;
	
	double octAR;
	double octBR;
	double octCR;
	double octDR;
	double octER;
	double octFR;
	double octGR;
	double octHR;
	double octFactorR;
	
	double nintAR;
	double nintBR;
	double nintCR;
	double nintDR;
	double nintER;
	double nintFR;
	double nintGR;
	double nintHR;
	double nintIR;
	double nintFactorR;
	
	double PrevHR;
	double PrevGR;
	double PrevFR;
	double PrevER;
	double PrevDR;
	double PrevCR;
	double PrevBR;
	double PrevAR;
	
    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;
    float H;
    float I;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
