/* ========================================
 *  Ensemble - Ensemble.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Ensemble_Ensemble_H
#define __Ensemble_Ensemble_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Ensemble {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class Ensemble final : public SfxCoreExtensionV1
{
public:
    Ensemble();
    ~Ensemble();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	const static int totalsamples = 65540;
	float dL[totalsamples];
	float dR[totalsamples];
	double sweep[49];
	int gcount;
	double airPrevL;
	double airEvenL;
	double airOddL;
	double airFactorL;
	double airPrevR;
	double airEvenR;
	double airOddR;
	double airFactorR;
	bool fpFlip;
    float A;
    float B;
    float C;
	float D;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
