/* ========================================
 *  EveryConsole - EveryConsole.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "EveryConsole.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::EveryConsole {

EveryConsole::EveryConsole()
{
	A = 0.0;
	B = 0.5;
	C = 0.5;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int EveryConsole::getParameterCount() const
{
  return kNumParameters;
}

void EveryConsole::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float EveryConsole::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void EveryConsole::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "ConType", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "InTrim", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "OutTrim", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void EveryConsole::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 11.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "Retro Ch", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Retro Bs", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Sin() Ch", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "aSin() Bs", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "C6 Ch", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "C6 Bs", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "C7 Ch", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "C7 Bs", kVstMaxParamStrLen); break;
			case 8: strncpy (text, "BShift Ch", kVstMaxParamStrLen); break;
			case 9: strncpy (text, "BShift Bs", kVstMaxParamStrLen); break;
			case 10: strncpy (text, "CZero Ch", kVstMaxParamStrLen); break;
			case 11: strncpy (text, "CZero Bs", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;
        case kParamB: float2string (B*2.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C*2.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void EveryConsole::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
