/* ========================================
 *  EverySlew - EverySlew.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __EverySlew_EverySlew_H
#define __EverySlew_EverySlew_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::EverySlew {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class EverySlew final : public SfxCoreExtensionV1
{
public:
    EverySlew();
    ~EverySlew();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	enum {
		prevSampL1,
		prevSampR1,
		invSampL1,
		invSampR1,
		threshold1,
		prevSampL2,
		prevSampR2,
		invSampL2,
		invSampR2,
		threshold2,
		prevSampL3,
		prevSampR3,
		invSampL3,
		invSampR3,
		threshold3,
		prevSampL4,
		prevSampR4,
		invSampL4,
		invSampR4,
		threshold4,
		prevSampL5,
		prevSampR5,
		invSampL5,
		invSampR5,
		threshold5,
		prevSampL6,
		prevSampR6,
		invSampL6,
		invSampR6,
		threshold6,
		prevSampL7,
		prevSampR7,
		invSampL7,
		invSampR7,
		threshold7,
		prevSampL8,
		prevSampR8,
		invSampL8,
		invSampR8,
		threshold8,
		prevSampL9,
		prevSampR9,
		invSampL9,
		invSampR9,
		threshold9,
		prevSampL10,
		prevSampR10,
		invSampL10,
		invSampR10,
		threshold10,
		gslew_total
	}; //fixed frequency pear filter for ultrasonics, stereo
	double gslew[gslew_total]; //probably worth just using a number here
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
