/* ========================================
 *  Golem - Golem.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Golem.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Golem {

Golem::Golem()
{
	A = 0.5;
	B = 0.5;
	C = 0.0;
	for(count = 0; count < 4098; count++) {p[count] = 0.0;}
	count = 0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	flip = true;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Golem::getParameterCount() const
{
  return kNumParameters;
}

void Golem::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Golem::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Golem::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Balance", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Offset", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Phase", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Golem::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamC: switch((int)( C * 5.999 )) //0 to almost edge of # of params
		{
			case 0: strncpy (text, "In/Mic", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Out/Mic", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "In/DI", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Out/DI", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "DefTime", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "DefGain", kVstMaxParamStrLen); break;
		 default: break; // unknown parameter, shouldn't happen!
		} break;
			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Golem::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
