/* ========================================
 *  GrooveWear - GrooveWear.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "GrooveWear.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::GrooveWear {

GrooveWear::GrooveWear()
{
	A = 0.064;
	B = 1.0;

	for(int count = 0; count < 21; count++) {
		aMidL[count] = 0.0;
		bMidL[count] = 0.0;
		cMidL[count] = 0.0;
		dMidL[count] = 0.0;
		aMidR[count] = 0.0;
		bMidR[count] = 0.0;
		cMidR[count] = 0.0;
		dMidR[count] = 0.0;
		fMid[count] = 0.0;
	}
	aMidPrevL = 0.0;
	bMidPrevL = 0.0;
	cMidPrevL = 0.0;
	dMidPrevL = 0.0;

	aMidPrevR = 0.0;
	bMidPrevR = 0.0;
	cMidPrevR = 0.0;
	dMidPrevR = 0.0;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int GrooveWear::getParameterCount() const
{
  return kNumParameters;
}

void GrooveWear::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float GrooveWear::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void GrooveWear::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Wear", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void GrooveWear::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void GrooveWear::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
