/* ========================================
 *  GuitarConditioner - GuitarConditioner.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "GuitarConditioner.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::GuitarConditioner {

GuitarConditioner::GuitarConditioner()
{
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	fpFlip = true;
	lastSampleTL = 0.0;
	lastSampleBL = 0.0; //for Slews. T for treble, B for bass
	iirSampleTAL = 0.0;
	iirSampleTBL = 0.0;
	iirSampleBAL = 0.0;
	iirSampleBBL = 0.0; //for Highpasses
	//this is reset: values being initialized only once. Startup values, whatever they are.
	lastSampleTR = 0.0;
	lastSampleBR = 0.0; //for Slews. T for treble, B for bass
	iirSampleTAR = 0.0;
	iirSampleTBR = 0.0;
	iirSampleBAR = 0.0;
	iirSampleBBR = 0.0; //for Highpasses
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int GuitarConditioner::getParameterCount() const
{
	return kNumParameters;
}

void GuitarConditioner::setParameter(int index, float value) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    }
	//we can also set other defaults here, and do calculations that only have to happen
	//once when parameters actually change. Here is the 'popup' setting its (global) values.
	//variables can also be set in the processreplacing loop, and there they'll be set every buffersize
	//here they're set when a parameter's actually changed, which should be less frequent, but
	//you must use global variables in the GuitarConditioner.h file to do it.
}

float GuitarConditioner::getParameter(int index) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void GuitarConditioner::getParameterName(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void GuitarConditioner::getParameterDisplay(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void GuitarConditioner::getParameterLabel(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
