/* ========================================
 *  GuitarConditioner - GuitarConditioner.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __GuitarConditioner_GuitarConditioner_H
#define __GuitarConditioner_GuitarConditioner_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::GuitarConditioner {
enum {
  kNumParameters = 0
}; //


class GuitarConditioner final : public SfxCoreExtensionV1
{
public:
    GuitarConditioner();
    ~GuitarConditioner();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	bool fpFlip;
	double lastSampleTL;
	double lastSampleBL; //for Slews
	double iirSampleTAL;
	double iirSampleTBL;
	double iirSampleBAL;
	double iirSampleBBL; //for Highpasses
	
	double lastSampleTR;
	double lastSampleBR; //for Slews
	double iirSampleTAR;
	double iirSampleTBR;
	double iirSampleBAR;
	double iirSampleBBR; //for Highpasses
	
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
