/* ========================================
 *  HermeTrim - HermeTrim.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "HermeTrim.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::HermeTrim {

HermeTrim::HermeTrim()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 0.5;
	E = 0.5;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int HermeTrim::getParameterCount() const
{
  return kNumParameters;
}

void HermeTrim::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float HermeTrim::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void HermeTrim::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Left", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Right", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Mid", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Side", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Master", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void HermeTrim::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*3.0)-1.5, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*3.0)-1.5, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C*3.0)-1.5, text, kVstMaxParamStrLen); break;
        case kParamD: float2string ((D*3.0)-1.5, text, kVstMaxParamStrLen); break;
        case kParamE: float2string ((E*3.0)-1.5, text, kVstMaxParamStrLen); break;			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void HermeTrim::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "dB", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
