/* ========================================
 *  Hermepass - Hermepass.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Hermepass_Hermepass_H
#define __Hermepass_Hermepass_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Hermepass {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Hermepass final : public SfxCoreExtensionV1
{
public:
    Hermepass();
    ~Hermepass();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double iirAL;
	double iirBL; //first stage is the flipping one, for lowest slope. It is always engaged, and is the highest one
	double iirCL; //we introduce the second pole at the same frequency, to become a pseudo-Capacitor behavior
	double iirDL;
	double iirEL;
	double iirFL; //our slope control will have a pow() on it so that the high orders are way to the right side
	double iirGL;
	double iirHL; //seven poles max, and the final pole is always at 20hz directly.
	
	double iirAR;
	double iirBR; //first stage is the flipping one, for lowest slope. It is always engaged, and is the highest one
	double iirCR; //we introduce the second pole at the same frequency, to become a pseudo-Capacitor behavior
	double iirDR;
	double iirER;
	double iirFR; //our slope control will have a pow() on it so that the high orders are way to the right side
	double iirGR;
	double iirHR; //seven poles max, and the final pole is always at 20hz directly.
	bool fpFlip;
	

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
