/* ========================================
 *  Holt2 - Holt2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Holt2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Holt2 {

Holt2::Holt2()
{
	A = 1.0;
	B = 0.5;
	C = 1.0;
	D = 1.0;
	E = 1.0;
	
	previousSampleAL = 0.0;
	previousTrendAL = 0.0;
	previousSampleBL = 0.0;
	previousTrendBL = 0.0;
	previousSampleCL = 0.0;
	previousTrendCL = 0.0;
	previousSampleDL = 0.0;
	previousTrendDL = 0.0;
	previousSampleEL = 0.0;
	previousTrendEL = 0.0;
	previousSampleFL = 0.0;
	previousTrendFL = 0.0;
	previousSampleGL = 0.0;
	previousTrendGL = 0.0;
	previousSampleHL = 0.0;
	previousTrendHL = 0.0;
	
	previousSampleAR = 0.0;
	previousTrendAR = 0.0;
	previousSampleBR = 0.0;
	previousTrendBR = 0.0;
	previousSampleCR = 0.0;
	previousTrendCR = 0.0;
	previousSampleDR = 0.0;
	previousTrendDR = 0.0;
	previousSampleER = 0.0;
	previousTrendER = 0.0;
	previousSampleFR = 0.0;
	previousTrendFR = 0.0;
	previousSampleGR = 0.0;
	previousTrendGR = 0.0;
	previousSampleHR = 0.0;
	previousTrendHR = 0.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Holt2::getParameterCount() const
{
  return kNumParameters;
}

void Holt2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Holt2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Holt2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Freq", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Reso", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Poles", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Holt2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C*8.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Holt2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
