/* ========================================
 *  Huge - Huge.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Huge_Huge_H
#define __Huge_Huge_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Huge {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Huge final : public SfxCoreExtensionV1
{
public:
    Huge();
    ~Huge();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double prev3L;
	double prev5L;
	double prev7L;
	double prev9L;
	double prev11L;
	double prev13L;
	double prevOutL;
	double limit3L;
	double limit5L;
	double limit7L;
	double limit9L;
	double limit11L;
	double limit13L;

	double prev3R;
	double prev5R;
	double prev7R;
	double prev9R;
	double prev11R;
	double prev13R;
	double prevOutR;
	double limit3R;
	double limit5R;
	double limit7R;
	double limit9R;
	double limit11R;
	double limit13R;

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
