/* ========================================
 *  Hull2 - Hull2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Hull2_Hull2_H
#define __Hull2_Hull2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Hull2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Hull2 final : public SfxCoreExtensionV1
{
public:
    Hull2();
    ~Hull2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double hullL[225];	
	double hullR[225];	
	int hullp;
	double hullbL[5];
	double hullbR[5];
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
