/* ========================================
 *  HypersonX - HypersonX.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __HypersonX_HypersonX_H
#define __HypersonX_HypersonX_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::HypersonX {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class HypersonX final : public SfxCoreExtensionV1
{
public:
    HypersonX();
    ~HypersonX();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	enum {
		fix_freq,
		fix_reso,
		fix_a0,
		fix_a1,
		fix_a2,
		fix_b1,
		fix_b2,
		fix_sL1,
		fix_sL2,
		fix_sR1,
		fix_sR2,
		fix_total
	}; //fixed frequency biquad filter for ultrasonics, stereo
	double fixA[fix_total];
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	static const int kA = 0;
	static const int kB = 1;
	static const int kC = 2;
	static const int kD = 3;
	static const int kE = 4;	
	static const int kF = 5;	
	static const int kG = 6;	
	
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
