/* ========================================
 *  Interstage - Interstage.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Interstage_Interstage_H
#define __Interstage_Interstage_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Interstage {
enum {
  kNumParameters = 0
}; //


class Interstage final : public SfxCoreExtensionV1
{
public:
    Interstage();
    ~Interstage();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double iirSampleAL;
	double iirSampleBL;
	double iirSampleCL;
	double iirSampleDL;
	double iirSampleEL;
	double iirSampleFL;
	double lastSampleL;
	double iirSampleAR;
	double iirSampleBR;
	double iirSampleCR;
	double iirSampleDR;
	double iirSampleER;
	double iirSampleFR;
	double lastSampleR;
	uint32_t fpdL;
	uint32_t fpdR;
	bool flip;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
