/* ========================================
 *  IronOxide5 - IronOxide5.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "IronOxide5.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::IronOxide5 {

IronOxide5::IronOxide5()
{
	A = 0.5; //0.0 input trim in dB -18 to +18, default 0 ((A*36.0)-18.0)
	B = 0.562341325190349; //15.0 ips 1.5 to 150.0 logarithmic. B*B
	C = 0.562341325190349; // (C*C) * (C*C) * 150 gives 15 ips (clamp to 1.5 minimum)
	//15.0  (0.316227766016838)squared * 150 gives 15 ips
	D = 0.5; //0.5 flutter 0 to 1
	E = 0.5; //0.5 noise 0 to 1
	F = 0.5; //0.0 output trim in dB -18 to +18, default 0 ((E*36.0)-18.0)
	G = 1.0; //1.0 inv/dry/wet -1 0 1 ((F*2.0)-1.0)
	//needs very fussy defaults to comply with unusual defaults
	
	for (int temp = 0; temp < 263; temp++) {dL[temp] = 0.0; dR[temp] = 0.0;}
	gcount = 0;
	
	fastIIRAL = fastIIRBL = slowIIRAL = slowIIRBL = 0.0;
	fastIIHAL = fastIIHBL = slowIIHAL = slowIIHBL = 0.0;
	iirSamplehAL = iirSamplehBL = 0.0;
	iirSampleAL = iirSampleBL = 0.0;
	prevInputSampleL = 0.0;
	
	fastIIRAR = fastIIRBR = slowIIRAR = slowIIRBR = 0.0;
	fastIIHAR = fastIIHBR = slowIIHAR = slowIIHBR = 0.0;
	iirSamplehAR = iirSamplehBR = 0.0;
	iirSampleAR = iirSampleBR = 0.0;
	prevInputSampleR = 0.0;
		
	flip = false;
	for (int temp = 0; temp < 99; temp++) {flL[temp] = 0.0; flR[temp] = 0.0;}
	
	fstoredcount = 0;	
	sweep = 0.0;
	rateof = 0.5;
	nextmax = 0.5;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int IronOxide5::getParameterCount() const
{
  return kNumParameters;
}

void IronOxide5::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        case kParamG: G = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float IronOxide5::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        case kParamG: return G; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void IronOxide5::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Input Trim", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Tape High", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Tape Low", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Flutter", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Noise", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Output Trim", kVstMaxParamStrLen); break;
		case kParamG: strncpy (text, "Inv/Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void IronOxide5::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (((A*36.0)-18.0), text, kVstMaxParamStrLen); break;
        case kParamB: float2string (((B*B)*(B*B)*148.5)+1.5, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (((C*C)*(C*C)*148.5)+1.5, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (((F*36.0)-18.0), text, kVstMaxParamStrLen); break;
        case kParamG: float2string (((G*2.0)-1.0), text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void IronOxide5::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "ips", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "ips", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamG: strncpy (text, "", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
