/* ========================================
 *  IronOxide5 - IronOxide5.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __IronOxide5_IronOxide5_H
#define __IronOxide5_IronOxide5_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::IronOxide5 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kNumParameters = 7
	
}; //


class IronOxide5 final : public SfxCoreExtensionV1
{
public:
    IronOxide5();
    ~IronOxide5();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
	
	double iirSamplehAL;
	double iirSamplehBL;
	double iirSampleAL;
	double iirSampleBL;
	double dL[264];
	double fastIIRAL;
	double fastIIRBL;
	double slowIIRAL;
	double slowIIRBL;
	double fastIIHAL;
	double fastIIHBL;
	double slowIIHAL;
	double slowIIHBL;
	double prevInputSampleL;

	double iirSamplehAR;
	double iirSamplehBR;
	double iirSampleAR;
	double iirSampleBR;
	double dR[264];
	double fastIIRAR;
	double fastIIRBR;
	double slowIIRAR;
	double slowIIRBR;
	double fastIIHAR;
	double fastIIHBR;
	double slowIIHAR;
	double slowIIHBR;
	double prevInputSampleR;
	
	int gcount;
	bool flip;
	
	double flL[100];
	double flR[100];
	
	int fstoredcount;
	double rateof;
	double sweep;
	double nextmax;
	
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
