/* ========================================
 *  IronOxideClassic2 - IronOxideClassic2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __IronOxideClassic2_IronOxideClassic2_H
#define __IronOxideClassic2_IronOxideClassic2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::IronOxideClassic2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kNumParameters = 3
}; //


class IronOxideClassic2 final : public SfxCoreExtensionV1
{
public:
    IronOxideClassic2();
    ~IronOxideClassic2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double iirSampleAL;
	double iirSampleBL;
	double dL[264];
	double fastIIRAL;
	double fastIIRBL;
	double slowIIRAL;
	double slowIIRBL;
	double lastRefL[7];
	
	double iirSampleAR;
	double iirSampleBR;
	double dR[264];
	double fastIIRAR;
	double fastIIRBR;
	double slowIIRAR;
	double slowIIRBR;
	double lastRefR[7];
	
	double biquadA[15];
	double biquadB[15];

	int cycle;
	int gcount;
	bool flip;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
