/* ========================================
 *  LRFlipTimer - LRFlipTimer.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "LRFlipTimer.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::LRFlipTimer {

LRFlipTimer::LRFlipTimer()
{
	A = 0.0;
	tick = 0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int LRFlipTimer::getParameterCount() const
{
  return kNumParameters;
}

void LRFlipTimer::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float LRFlipTimer::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void LRFlipTimer::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Minutes", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void LRFlipTimer::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*9.0)+1.0, text, kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void LRFlipTimer::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
