/* ========================================
 *  Logical4 - Logical4.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Logical4_Logical4_H
#define __Logical4_Logical4_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Logical4 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Logical4 final : public SfxCoreExtensionV1
{
public:
    Logical4();
    ~Logical4();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
	
	//begin ButterComp
	double controlAposL;
	double controlAnegL;
	double controlBposL;
	double controlBnegL;
	double targetposL;
	double targetnegL;
	double controlAposBL;
	double controlAnegBL;
	double controlBposBL;
	double controlBnegBL;
	double targetposBL;
	double targetnegBL;
	double controlAposCL;
	double controlAnegCL;
	double controlBposCL;
	double controlBnegCL;
	double targetposCL;
	double targetnegCL;
	double avgAL;
	double avgBL;
	double avgCL;
	double avgDL;
	double avgEL;
	double avgFL;
	double nvgAL;
	double nvgBL;
	double nvgCL;
	double nvgDL;
	double nvgEL;
	double nvgFL;
	//end ButterComp
	
	//begin Power Sag
	double dL[1000];
	double controlL;
	double bL[1000];
	double controlBL;
	double cL[1000];
	double controlCL;
	//end Power Sag
	
	//begin ButterComp
	double controlAposR;
	double controlAnegR;
	double controlBposR;
	double controlBnegR;
	double targetposR;
	double targetnegR;
	double controlAposBR;
	double controlAnegBR;
	double controlBposBR;
	double controlBnegBR;
	double targetposBR;
	double targetnegBR;
	double controlAposCR;
	double controlAnegCR;
	double controlBposCR;
	double controlBnegCR;
	double targetposCR;
	double targetnegCR;
	double avgAR;
	double avgBR;
	double avgCR;
	double avgDR;
	double avgER;
	double avgFR;
	double nvgAR;
	double nvgBR;
	double nvgCR;
	double nvgDR;
	double nvgER;
	double nvgFR;
	//end ButterComp
	
	//begin Power Sag
	double dR[1000];
	double controlR;
	double bR[1000];
	double controlBR;
	double cR[1000];
	double controlCR;
	//end Power Sag
	
	int gcount;
	
    
	bool fpFlip;
	//default stuff
	uint32_t fpdL;
	uint32_t fpdR;

    float A;
    float B;
    float C;
    float D;
	float E;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
