/* ========================================
 *  MultiBandDistortion - MultiBandDistortion.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __MultiBandDistortion_MultiBandDistortion_H
#define __MultiBandDistortion_MultiBandDistortion_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::MultiBandDistortion {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kParamH = 7,
	kParamI = 8,
  kNumParameters = 9
}; //


class MultiBandDistortion final : public SfxCoreExtensionV1
{
public:
    MultiBandDistortion();
    ~MultiBandDistortion();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double ataLast3SampleL;
	double ataLast2SampleL;
	double ataLast1SampleL;
	double ataHalfwaySampleL;
	double ataHalfDrySampleL;
	double ataHalfDiffSampleL;
	double ataAL;
	double ataBL;
	double ataCL;
	double ataDecayL;
	double ataUpsampleHighTweakL;
	double ataDrySampleL;
	double ataDiffSampleL;
	double ataPrevDiffSampleL;
	double iirSampleAL;
	double iirSampleBL;

	bool ataFlip; //end defining of antialiasing variables

	double ataLast3SampleR;
	double ataLast2SampleR;
	double ataLast1SampleR;
	double ataHalfwaySampleR;
	double ataHalfDrySampleR;
	double ataHalfDiffSampleR;
	double ataAR;
	double ataBR;
	double ataCR;
	double ataDecayR;
	double ataUpsampleHighTweakR;
	double ataDrySampleR;
	double ataDiffSampleR;
	double ataPrevDiffSampleR;
	double iirSampleAR;
	double iirSampleBR;
		
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;
    float H;
    float I;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
