/* ========================================
 *  Overheads - Overheads.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Overheads_Overheads_H
#define __Overheads_Overheads_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Overheads {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Overheads final : public SfxCoreExtensionV1
{
public:
    Overheads();
    ~Overheads();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
	
	double ovhGain;
	double ovhL[130];
	double ovhR[130];
	int ovhCount;
	
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
