/* ========================================
 *  PaulDither - PaulDither.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "PaulDither.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::PaulDither {

PaulDither::PaulDither()
{
	A = 1.0;
	B = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	previousDitherL = 0.0;
	previousDitherR = 0.0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int PaulDither::getParameterCount() const
{
  return kNumParameters;
}

void PaulDither::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
		default: break; // unknown parameter, shouldn't happen!
    }
}

float PaulDither::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void PaulDither::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Quant", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "DeRez", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void PaulDither::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 1.999 )) //0 to almost edge of # of params
		{	case 0: strncpy (text, "CD 16", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "HD 24", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break; //completed consoletype 'popup' parameter, exit
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void PaulDither::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
