/* ========================================
 *  PodcastDeluxe - PodcastDeluxe.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __PodcastDeluxe_PodcastDeluxe_H
#define __PodcastDeluxe_PodcastDeluxe_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::PodcastDeluxe {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class PodcastDeluxe final : public SfxCoreExtensionV1
{
public:
    PodcastDeluxe();
    ~PodcastDeluxe();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double d1L[503];
	double d2L[503];
	double d3L[503];
	double d4L[503];
	double d5L[503];
	//the phase rotator
	
	double c1L;
	double c2L;
	double c3L;
	double c4L;
	double c5L;
	//the compressor
	
	double lastSampleL;
	double lastOutSampleL;
	
	double d1R[503];
	double d2R[503];
	double d3R[503];
	double d4R[503];
	double d5R[503];
	
	int tap1, tap2, tap3, tap4, tap5, maxdelay1, maxdelay2, maxdelay3, maxdelay4, maxdelay5;
	//the phase rotator
	
	double c1R;
	double c2R;
	double c3R;
	double c4R;
	double c5R;
	//the compressor
	
	double lastSampleR;
	double lastOutSampleR;
	
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
