/* ========================================
 *  Point - Point.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Point.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Point {

Point::Point()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	nibAL = 0.0;
	nobAL = 0.0;
	nibBL = 0.0;
	nobBL = 0.0;
	nibAR = 0.0;
	nobAR = 0.0;
	nibBR = 0.0;
	nobBR = 0.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	fpFlip = true;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Point::getParameterCount() const
{
  return kNumParameters;
}

void Point::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Point::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Point::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Input Trim", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Point", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Reaction Speed", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Point::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*24.0)-12.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Point::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, " ", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
