/* ========================================
 *  Pressure4 - Pressure4.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Pressure4_Pressure4_H
#define __Pressure4_Pressure4_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Pressure4 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class Pressure4 final : public SfxCoreExtensionV1
{
public:
    Pressure4();
    ~Pressure4();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double muVary;
	double muAttack;
	double muNewSpeed;
	double muSpeedA;
	double muSpeedB;
	double muCoefficientA;
	double muCoefficientB;
	uint32_t fpdL;
	uint32_t fpdR;
	bool flip;

    float A;
    float B;
    float C; //parameters. Always 0-1, and we scale/alter them elsewhere.
    float D;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
