/* ========================================
 *  PurestAir - PurestAir.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "PurestAir.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::PurestAir {

PurestAir::PurestAir()
{
	A = 0.5;
	B = 0.0;
	C = 1.0;
	last1SampleL = 0.0;
	halfwaySampleL = halfDrySampleL = halfDiffSampleL = diffSampleL = 0.0;
	lastSampleL = 0.0;
	s1L = s2L = s3L = 0.0;
	applyL = 0.0;
	last1SampleR = 0.0;
	halfwaySampleR = halfDrySampleR = halfDiffSampleR = diffSampleR = 0.0;
	lastSampleR = 0.0;
	s1R = s2R = s3R = 0.0;
	applyR = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int PurestAir::getParameterCount() const
{
  return kNumParameters;
}

void PurestAir::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float PurestAir::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void PurestAir::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Boost", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Limit", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void PurestAir::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void PurestAir::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
