/* ========================================
 *  PurestConsole2Channel - PurestConsole2Channel.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "PurestConsole2Channel.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::PurestConsole2Channel {

PurestConsole2Channel::PurestConsole2Channel()
{
	for (int x = 0; x < 15; x++) {biquadA[x] = 0.0;}
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int PurestConsole2Channel::getParameterCount() const
{
  return kNumParameters;
}

void PurestConsole2Channel::setParameter(int index, float value) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    }
}

float PurestConsole2Channel::getParameter(int index) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void PurestConsole2Channel::getParameterName(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void PurestConsole2Channel::getParameterDisplay(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void PurestConsole2Channel::getParameterLabel(int index, char *text) {
    switch (index) {
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
