/* ========================================
 *  SampleDelay - SampleDelay.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "SampleDelay.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::SampleDelay {

SampleDelay::SampleDelay()
{
	A = 0.0;
	B = 0.0;
	C = 0.0;
	D = 1.0;
	
	for(int count = 0; count < 16385; count++) {pL[count] = 0.0;pR[count] = 0.0;}
	gcount = 0;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int SampleDelay::getParameterCount() const
{
  return kNumParameters;
}

void SampleDelay::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float SampleDelay::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void SampleDelay::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "ms", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Samples", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Subsamp", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Inv/Wet", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void SampleDelay::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: int2string (floor(A*100.0), text, kVstMaxParamStrLen); break;
        case kParamB: int2string (floor(B*10.0), text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string ((D*2.0)-1.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void SampleDelay::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
