/* ========================================
 *  SampleDelay - SampleDelay.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __SampleDelay_SampleDelay_H
#define __SampleDelay_SampleDelay_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::SampleDelay {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class SampleDelay final : public SfxCoreExtensionV1
{
public:
    SampleDelay();
    ~SampleDelay();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double pL[16386];
	double pR[16386];
	int gcount;

    float A;
    float B;
    float C;
    float D;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
