/* ========================================
 *  Slew - Slew.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#include "Slew.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Slew {

Slew::Slew()
{
	gain = 0.0;
	lastSampleL = 0.0;
	lastSampleR = 0.0;
}

Slew::~Slew() 
{
}

int Slew::getParameterCount() const
{
  return kNumParameters;
}

void Slew::setParameter(int index, float value) {
    switch (index) {
        case kSlewParam:
            gain = value;
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

float Slew::getParameter(int index) {
    switch (index) {
        case kSlewParam:
            return gain;
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
	return 0.0;
}

void Slew::getParameterName(int index, char *text) {
    switch (index) {
        case kSlewParam:
            strncpy (text, "Clamping", kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

void Slew::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kSlewParam:
            float2string (gain, text, kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

void Slew::getParameterLabel(int index, char *text) {
    switch (index) {
        case kSlewParam:
            strncpy (text, "", kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
