/* ========================================
 *  Slew2 - Slew2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Slew2_Slew2_H
#define __Slew2_Slew2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Slew2 {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class Slew2 final : public SfxCoreExtensionV1
{
public:
    Slew2();
    ~Slew2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double LataLast3Sample;
	double LataLast2Sample;
	double LataLast1Sample;
	double LataHalfwaySample;
	double LataHalfDrySample;
	double LataHalfDiffSample;
	double LataA;
	double LataB;
	double LataC;
	double LataDecay;
	double LataUpsampleHighTweak;
	double LataDrySample;
	double LataDiffSample;
	double LataPrevDiffSample;
	
	double RataLast3Sample;
	double RataLast2Sample;
	double RataLast1Sample;
	double RataHalfwaySample;
	double RataHalfDrySample;
	double RataHalfDiffSample;
	double RataA;
	double RataB;
	double RataC;
	double RataDecay;
	double RataUpsampleHighTweak;
	double RataDrySample;
	double RataDiffSample;
	double RataPrevDiffSample;
	
	bool LataFlip; //end defining of antialiasing variables
	bool RataFlip; //end defining of antialiasing variables

	double lastSampleL;
	double lastSampleR;
	
	uint32_t fpdL;
	uint32_t fpdR;
	
    float A;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
