/* ========================================
 *  Slew - Slew.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#include "Slew.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

namespace airwinconsolidated::Slew {

void Slew::processBlock(float **inputs, float **outputs, int sampleFrames) 
{
    float* in1  =  inputs[0];
    float* in2  =  inputs[1];
    float* out1 = outputs[0];
    float* out2 = outputs[1];

	double overallscale = 1.0;
	overallscale /= 44100.0;
	overallscale *= getSampleRate();
	
	double inputSampleL;
	double inputSampleR;
	double outputSampleL;
	double outputSampleR;
	
	double clamp;
	double threshold = pow((1-gain),4)/overallscale;


    
    while (--sampleFrames >= 0)
    {
		inputSampleL = *in1;
		inputSampleR = *in2;
		if (fabs(inputSampleL)<1.18e-23) inputSampleL = fpdL * 1.18e-17;
		if (fabs(inputSampleR)<1.18e-23) inputSampleR = fpdR * 1.18e-17;

		clamp = inputSampleL - lastSampleL;
		outputSampleL = inputSampleL;
		if (clamp > threshold)
			outputSampleL = lastSampleL + threshold;
		if (-clamp > threshold)
			outputSampleL = lastSampleL - threshold;
		lastSampleL = outputSampleL;

		clamp = inputSampleR - lastSampleR;
		outputSampleR = inputSampleR;
		if (clamp > threshold)
			outputSampleR = lastSampleR + threshold;
		if (-clamp > threshold)
			outputSampleR = lastSampleR - threshold;
		lastSampleR = outputSampleR;
		
		*out1 = outputSampleL;
		*out2 = outputSampleR;

		in1++;
		in2++;
		out1++;
		out2++;
    }
}

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
