/* ========================================
 *  SlewSonic - SlewSonic.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __SlewSonic_SlewSonic_H
#define __SlewSonic_SlewSonic_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::SlewSonic {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class SlewSonic final : public SfxCoreExtensionV1
{
public:
    SlewSonic();
    ~SlewSonic();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double biquadA[15];
	double lastSampleAL;
	double lastSampleAR;
	double biquadB[15];
	double lastSampleBL;
	double lastSampleBR;
	double biquadC[15];
	double lastSampleCL;
	double lastSampleCR;
	double biquadD[15];
	

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
