/* ========================================
 *  Smooth - Smooth.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Smooth.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Smooth {

Smooth::Smooth()
{
	A = 0.0;
	B = 1.0;
	C = 1.0;
	
	lastSampleAL = 0.0;
	gainAL = 1.0;
	lastSampleBL = 0.0;
	gainBL = 1.0;
	lastSampleCL = 0.0;
	gainCL = 1.0;
	lastSampleDL = 0.0;
	gainDL = 1.0;
	lastSampleEL = 0.0;
	gainEL = 1.0;

	lastSampleAR = 0.0;
	gainAR = 1.0;
	lastSampleBR = 0.0;
	gainBR = 1.0;
	lastSampleCR = 0.0;
	gainCR = 1.0;
	lastSampleDR = 0.0;
	gainDR = 1.0;
	lastSampleER = 0.0;
	gainER = 1.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Smooth::getParameterCount() const
{
  return kNumParameters;
}

void Smooth::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Smooth::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Smooth::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Smooth", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Smooth::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Smooth::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
