/* ========================================
 *  Smooth - Smooth.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Smooth_Smooth_H
#define __Smooth_Smooth_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Smooth {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Smooth final : public SfxCoreExtensionV1
{
public:
    Smooth();
    ~Smooth();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double lastSampleAL;
	double gainAL;
	double lastSampleBL;
	double gainBL;
	double lastSampleCL;
	double gainCL;
	double lastSampleDL;
	double gainDL;
	double lastSampleEL;
	double gainEL;

	double lastSampleAR;
	double gainAR;
	double lastSampleBR;
	double gainBR;
	double lastSampleCR;
	double gainCR;
	double lastSampleDR;
	double gainDR;
	double lastSampleER;
	double gainER;
	
    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
