/* ========================================
 *  StarChild2 - StarChild2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __StarChild2_StarChild2_H
#define __StarChild2_StarChild2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::StarChild2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class StarChild2 final : public SfxCoreExtensionV1
{
public:
    StarChild2();
    ~StarChild2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double lastRefL[7];
	double lastRefR[7];
	int cycle;
	
	double d[45102];
	int dCount;
	
	int p[171];
	int t[171];
	double outL[171];
	double outR[171];
	int pitchCounter;
	int increment;
	int dutyCycle;
	
	double wearL[11];
	double wearR[11];
	double factor[11];		
	double wearLPrev;
	double wearRPrev;
	
    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
