/* ========================================
 *  Swell - Swell.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Swell_Swell_H
#define __Swell_Swell_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Swell {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Swell final : public SfxCoreExtensionV1
{
public:
    Swell();
    ~Swell();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff


	double swellL;
	double swellR;
	bool louderL;
	bool louderR;
	
    float A;
    float B;
    float C;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
