/* ========================================
 *  TapeDelay - TapeDelay.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __TapeDelay_TapeDelay_H
#define __TapeDelay_TapeDelay_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::TapeDelay {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
  kNumParameters = 6
}; //


class TapeDelay final : public SfxCoreExtensionV1
{
public:
    TapeDelay();
    ~TapeDelay();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	int pL[258];
	int pR[258];
	double dL[44100];
	double dR[44100];
	int gcount;
	int delay;
	int maxdelay;
	int chase;		
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
