/* ========================================
 *  Verbity2 - Verbity2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Verbity2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Verbity2 {

Verbity2::Verbity2()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 1.0;
	
	iirAL = 0.0;
	iirBL = 0.0;
	
	iirAR = 0.0;
	iirBR = 0.0;
	
	//for(int count = 0; count < 5190; count++) {aZL[count] = 0.0; aZR[count] = 0.0;}
	
	for(int count = 0; count < 5004; count++) {aAL[count] = 0.0; aAR[count] = 0.0;} //AFKPU
	for(int count = 0; count < 4952; count++) {aFL[count] = 0.0; aFR[count] = 0.0;}
	for(int count = 0; count < 4920; count++) {aKL[count] = 0.0; aKR[count] = 0.0;}
	for(int count = 0; count < 4800; count++) {aPL[count] = 0.0; aPR[count] = 0.0;}
	for(int count = 0; count < 4752; count++) {aUL[count] = 0.0; aUR[count] = 0.0;}
	
	for(int count = 0; count < 4350; count++) {aBL[count] = 0.0; aBR[count] = 0.0;} //BGLQV
	for(int count = 0; count < 4158; count++) {aGL[count] = 0.0; aGR[count] = 0.0;}
	for(int count = 0; count < 3930; count++) {aLL[count] = 0.0; aLR[count] = 0.0;}
	for(int count = 0; count < 3530; count++) {aQL[count] = 0.0; aQR[count] = 0.0;}
	for(int count = 0; count < 3330; count++) {aVL[count] = 0.0; aVR[count] = 0.0;}
	
	for(int count = 0; count < 3324; count++) {aCL[count] = 0.0; aCR[count] = 0.0;} //CHMRW
	for(int count = 0; count < 2792; count++) {aHL[count] = 0.0; aHR[count] = 0.0;}
	for(int count = 0; count < 2768; count++) {aML[count] = 0.0; aMR[count] = 0.0;}
	for(int count = 0; count < 2390; count++) {aRL[count] = 0.0; aRR[count] = 0.0;}
	for(int count = 0; count < 2348; count++) {aWL[count] = 0.0; aWR[count] = 0.0;}
	
	for(int count = 0; count < 2142; count++) {aDL[count] = 0.0; aDR[count] = 0.0;} //DINSX
	for(int count = 0; count < 1812; count++) {aIL[count] = 0.0; aIR[count] = 0.0;}
	for(int count = 0; count < 1734; count++) {aNL[count] = 0.0; aNR[count] = 0.0;}
	for(int count = 0; count < 1172; count++) {aSL[count] = 0.0; aSR[count] = 0.0;}
	for(int count = 0; count < 788; count++) {aXL[count] = 0.0; aXR[count] = 0.0;}
	
	for(int count = 0; count < 678; count++) {aEL[count] = 0.0; aER[count] = 0.0;} //EJOTY
	for(int count = 0; count < 644; count++) {aJL[count] = 0.0; aJR[count] = 0.0;}
	for(int count = 0; count < 440; count++) {aOL[count] = 0.0; aOR[count] = 0.0;}
	for(int count = 0; count < 350; count++) {aTL[count] = 0.0; aTR[count] = 0.0;}
	for(int count = 0; count < 282; count++) {aYL[count] = 0.0; aYR[count] = 0.0;}
	
	feedbackAL = 0.0;
	feedbackBL = 0.0;
	feedbackCL = 0.0;
	feedbackDL = 0.0;
	feedbackEL = 0.0;
	
	previousAL = 0.0;
	previousBL = 0.0;
	previousCL = 0.0;
	previousDL = 0.0;
	previousEL = 0.0;
	
	feedbackAR = 0.0;
	feedbackBR = 0.0;
	feedbackCR = 0.0;
	feedbackDR = 0.0;
	feedbackER = 0.0;
	
	previousAR = 0.0;
	previousBR = 0.0;
	previousCR = 0.0;
	previousDR = 0.0;
	previousER = 0.0;
	
	for(int count = 0; count < 6; count++) {lastRefL[count] = 0.0; lastRefR[count] = 0.0;}
	
	countA = 1;
	countB = 1;
	countC = 1;
	countD = 1;	
	countE = 1;
	countF = 1;
	countG = 1;
	countH = 1;
	countI = 1;
	countJ = 1;
	countK = 1;
	countL = 1;
	countM = 1;
	countN = 1;
	countO = 1;
	countP = 1;
	countQ = 1;
	countR = 1;
	countS = 1;
	countT = 1;
	countU = 1;
	countV = 1;
	countW = 1;
	countX = 1;
	countY = 1;
	countZ = 1;
	
	cycle = 0;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Verbity2::getParameterCount() const
{
  return kNumParameters;
}

void Verbity2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Verbity2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Verbity2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "RmSize", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Sustain", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Mulch", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Wetness", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Verbity2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Verbity2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
