/* ========================================
 *  VoiceTrick - VoiceTrick.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __VoiceTrick_VoiceTrick_H
#define __VoiceTrick_VoiceTrick_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::VoiceTrick {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class VoiceTrick final : public SfxCoreExtensionV1
{
public:
    VoiceTrick();
    ~VoiceTrick();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double iirLowpassA;
	double iirLowpassB;
	double iirLowpassC;
	double iirLowpassD;
	double iirLowpassE;
	double iirLowpassF;
	int count;
	double lowpassChase;
	double lowpassAmount;
	double lastLowpass;	
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
