/* ========================================
 *  Weight - Weight.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Weight_Weight_H
#define __Weight_Weight_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Weight {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Weight final : public SfxCoreExtensionV1
{
public:
    Weight();
    ~Weight();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
	double previousSampleL[9];
	double previousTrendL[9];
	double previousSampleR[9];
	double previousTrendR[9];

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
