/* ========================================
 *  ZOutputStage - ZOutputStage.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ZOutputStage_ZOutputStage_H
#define __ZOutputStage_ZOutputStage_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ZOutputStage {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class ZOutputStage final : public SfxCoreExtensionV1
{
public:
    ZOutputStage();
    ~ZOutputStage();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double biquadE[15];
	double biquadF[15];
	double iirSampleAL;
	double iirSampleAR;

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
