#ifndef SFX_CORE_NEURAL_AMP_MODELER_H
#define SFX_CORE_NEURAL_AMP_MODELER_H

#include "../../typedefs.h"

#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER

#include <string>
#include <vector>

class NeuralAmpModeler;

struct SfxCoreNeuralAmpModeler
{
  i32 input = 0;
  i32 gate = -800;
  i32 bass = 50;
  i32 middle = 50;
  i32 treble = 50;
  i32 output = 0;
  bool gateEnabled = true;
  bool eqEnabled = true;
  bool normalizeEnabled = true;
  bool irEnabled = true;
  bool namEnabled = true;
  i32 nextIrFileIndex = -1;
  i32 nextNamFileIndex = -1;

  NeuralAmpModeler* neuralAmpModeler;
  i32 loadedIrFileIndex = -1;
  i32 loadedNamFileIndex = -1;

  static void init();

  SfxCoreNeuralAmpModeler();
  i32 getpar(i32 npar);
  void changepar(i32 npar, i32 value);
  void processBlock(const f32* const* inBlock, f32** outBlock, const i32 blockSize);
};

#endif // SHR3D_SFX_CORE_NEURALAMPMODELER

#endif // SFX_CORE_NEURAL_AMP_MODELER_H
