/*
  rakarrack - a guitar effects software

 Compressor.h  -  Compressor Effect definitions
 Based on artscompressor.cc by Matthias Kretz <kretz@kde.org>
 Stefan Westerfeld <stefan@space.twc.de>

  Copyright (C) 2008-2010 Josep Andreu
  Author: Josep Andreu & Ryan Billing

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef COMPRESSOR_H
#define COMPRESSOR_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "Defines.h"

class Compressor
{
public:
  Compressor();

  void processBlock(f32** inOutBlock, i32 blockSize);

  void changepar(i32 np, i32 value);
  void setpreset(i32 npreset);
  i32 getpar(i32 npar);
  void cleanup();

  // Compressor
  i32 tatt = 20;			// attack time  (ms)
  i32 trel = 50;			// release time (ms)
  i32 tratio = 4;
  i32 toutput = -10;
  i32 tthreshold = -24;
  i32 a_out = 1;
  i32 stereo = 0;
  i32 tknee = 30;
  i32 peak = 0;
  i32 clipping = 0;
  i32 limit = 0;

private:

  f32 rvolume = 0.0f;
  f32 lvolume = 0.0f;
  f32 rvolume_db = 0.0f;
  f32 lvolume_db = 0.0f;
  f32 thres_db;		// threshold
  f32 knee;
  f32 thres_mx;
  f32 kpct = 0.0f;
  f32 ratio = 1.0f;			// ratio
  f32 kratio;			// ratio maximum for knee region
  f32 eratio;			// dynamic ratio
  f32 makeup;			// make-up gain
  f32 makeuplin;

  f32 outlevel;
  f32 att;
  f32 attr = 1.0f;
  f32 attl = 1.0f;
  f32 rel;
  f32 relr = 1.0f;
  f32 rell = 1.0f;
  f32 relcnst, attconst;
  i32 ltimer = 0;
  i32 rtimer = 0;
  i32 hold;

  f32 rgain = 1.0f;
  f32 rgain_old = 1.0f;

  f32 lgain = 1.0f;
  f32 lgain_old = 1.0f;

  f32 lgain_t = 1.0f;
  f32 rgain_t = 1.0f;

  f32 coeff_kratio;
  f32 coeff_ratio;
  f32 coeff_knee;
  f32 coeff_kk;
  f32 lpeak = 0.0f;
  f32 rpeak = 0.0f;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
