/*
  ZynAddSubFX - a software synthesizer

  EffectLFO.h - Stereo LFO used by some effects
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu & Ryan Billing


  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef EFFECT_LFO_H
#define EFFECT_LFO_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "Defines.h"

class EffectLFO
{
public:
  EffectLFO();
  void effectlfoout(f32& outl, f32& outr);
  void updateparams();
  i32 Pfreq;
  i32 Prandomness;
  i32 PLFOtype;
  i32 Pstereo;	//"64"=0
private:
  f32 getlfoshape(f32 x);

  f32 xl, xr;
  f32 incx;
  f32 ampl1, ampl2, ampr1, ampr2;	//necesar pentru "randomness"
  f32 lfointensity;
  f32 lfornd;
  i32 lfotype;

  //Lorenz Fractal parameters
  f32 x0, y0, z0, x1, y1, z1, radius;
  f32 h;
  f32 a;
  f32 b;
  f32 c;
  f32 scale;
  f32 iperiod;
  f32 ratediv;

  //Sample/Hold
  i32 holdflag;  //toggle left/right channel changes
  f32 tca, tcb, maxrate;
  f32 rreg, lreg, xlreg, xrreg, oldrreg, oldlreg;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
