/*
  ZynAddSubFX - a software synthesizer

  metronome.h - Stereo LFO used by some effects
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu & Ryan Billing


  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef EFFECT_METRONOME_H
#define EFFECT_METRONOME_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "AnalogFilter.h"

class Metronome
{
public:
  Metronome();
  void cleanup();
  void metronomeout(f32* tickout, i32 blockSize);
  void set_tempo(i32 bpm);
  void set_meter(i32 counts);
  i32 markctr;

private:
  i32 tick_interval;
  i32 tickctr;
  i32 meter;
  i32 tickper;
  i32 ticktype;

  AnalogFilter dulltick;
  AnalogFilter sharptick;
  AnalogFilter hpf;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
