/*

  Resample.C  -  Class
  Using Erik de Castro Lopo libsamplerate
  Copyright (C) 2008-2009 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include "Resample.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

Resample::Resample(i32 type)
{
  statel = src_new(type, 1, &errorl);
  stater = src_new(type, 1, &errorr);
}

void Resample::cleanup()
{
  src_reset(statel);
  src_reset(stater);
}

void Resample::processBlock(f32** inBlock, f32** outBlock, i32 frames, f64 ratio)
{
  const i32 o_frames = lrint((f64)frames * ratio);
  srcinfol.data_in = inBlock[0];
  srcinfol.input_frames = frames;
  srcinfol.data_out = outBlock[0];
  srcinfol.output_frames = o_frames;
  srcinfol.src_ratio = ratio;
  srcinfol.end_of_input = 0;

  srcinfor.data_in = inBlock[1];
  srcinfor.input_frames = frames;
  srcinfor.data_out = outBlock[1];
  srcinfor.output_frames = o_frames;
  srcinfor.src_ratio = ratio;
  srcinfor.end_of_input = 0;

  errorl = src_process(statel, &srcinfol);
  errorr = src_process(stater, &srcinfor);
}

void Resample::mono_out(const f32* inl, f32* outl, i32 frames, f64 ratio, i32 o_frames)
{
  srcinfol.data_in = inl;
  srcinfol.input_frames = frames;
  srcinfol.data_out = outl;
  srcinfol.output_frames = o_frames;
  srcinfol.src_ratio = ratio;
  srcinfol.end_of_input = 0;

  errorl = src_process(statel, &srcinfol);
}

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK
