/*
  Arpie.h - Echo Effect w/ arpeggiated delay
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  Arpeggiated Echo by Ryan Billing (a.k.a. Transmogrifox)

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef ARPIE_H
#define ARPIE_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"

#define MAXHARMS  8    // max number of harmonics available

class Arpie
{
public:
  Arpie();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  
  f32 outvolume;

private:
  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 Ppanning = 64;	//Panning
  i32 Pdelay = 60;
  i32 Plrdelay = 100;	// L/R delay difference
  i32 Plrcross = 100;	// L/R Mixing
  i32 Pfb = 40;		//Feed-back-ul
  i32 Phidamp = 60;
  i32 Preverse;
  i32 Ppattern;
  i32 Pharms = 3;
  i32 Psubdiv = 1;


  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setdelay(i32 Pdelay);
  void setlrdelay(i32 Plrdelay);
  void setlrcross(i32 Plrcross);
  void setfb(i32 Pfb);
  void sethidamp(i32 Phidamp);
  void setreverse(i32 Preverse);
  void setpattern(i32 Ppattern);


  //Parametrii reali
  void initdelays();

  i32 dl;
  i32 dr;
  i32 delay;
  i32 lrdelay = 0;
  i32 kl;
  i32 kr;
  i32 rvkl;
  i32 rvkr;
  i32 rvfl;
  i32 rvfr;
  static const i32 maxx_delay = SAMPLE_RATE * MAX_DELAY;
  i32 fade;
  i32 harmonic = 1;
  i32 envcnt;
  i32 invattack;
  i32 subdiv;
  i32 pattern[MAXHARMS];

  f32 panning, lrcross, fb, hidamp, reverse;
  f32 ldelay[maxx_delay];
  f32 rdelay[maxx_delay];

  f32 oldl, oldr;		//pt. lpf
  f32  Srate_Attack_Coeff, envattack, envswell;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
