/*
  ZynAddSubFX - a software synthesizer

  Distorsion.h - Distorsion Effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu  & Ryan Billing

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef NEWDIST_H
#define NEWDIST_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/Waveshaper.h"
#include "../common/FilterParams.h"

//Waveshaping(called by Distorsion effect and waveshape from OscilGen)
// void waveshapesmps (i32 n, f32 * smps, i32 type,
// 		    i32 drive);

class Derelict
{
public:
  Derelict();
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  void applyfilters(f32** inBlock, i32 blockSize);

  f32 outvolume;
  
  f32 inpll[4096];
  f32 inplr[4096];

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setlrcross(i32 Plrcross);
  void setoctave(i32 Poctave);
  void setlpf(i32 Plpf);
  void sethpf(i32 Phpf);


  //Parametrii
  i32 Pvolume;	//Volumul or E/R
  i32 Ppanning;	//Panning
  i32 Plrcross;	// L/R Mixing
  i32 Pdrive;		//the input amplification
  i32 Plevel;		//the ouput amplification
  i32 Ptype;		//Distorsion type
  i32 Pnegate;	//if the input is negated 
  i32 Plpf;		//lowpass filter
  i32 Phpf;		//highpass filter
  i32 Prfreq;
  i32 Pprefiltering;	//if you want to do the filtering before the distorsion
  i32 Poctave;	//mix sub octave


  f32 rfreq;
  f32 panning, lrcross, octave_memoryl, togglel, octave_memoryr, toggler, octmix;
  f32 octoutl[Const::audioMaximumPossibleBlockSize];
  f32 octoutr[Const::audioMaximumPossibleBlockSize];


  //Parametrii reali
  AnalogFilter lpfl;
  AnalogFilter lpfr;
  AnalogFilter hpfl;
  AnalogFilter hpfr;
  AnalogFilter blockDCl;
  AnalogFilter blockDCr;
  AnalogFilter DCl;
  AnalogFilter DCr;
  Waveshaper wshapel;
  Waveshaper wshaper;


  class Filter* filterl, * filterr;

  FilterParams filterpars;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
